	.la	2112			; addr of compilation - hardcoded

start:
	call	@#150170		; fix for starting from DOS
	mov	#177663,R3		; palettes port
	mov	#1,R0
	emt	51			; set screen mode
	emt	53			; set background + foreground colors
	emt	62			; clear screen (background color #1)
	tst	(R0)+			; R0=3
	emt	53			; set colors

loop:	mov	#4*8.,R0
	mov	#30.,R1
	emt	66			; set graph coords
	mov	#28.*8.,R0
	mov	#256.-32.,R1
	emt	76			; draw filled rectangle

	mov	#400,R4			; header size
	mov	#6000,R2		; long pilot
	call	loadblock			; header
	jsr	R1,print
	.word	3*400+4			; XY-coords for msg

	mov	(pc)+,R4
len:	.word	4000			; data size
	mov	pc,R2			; short pilot
	call	loadblock			; data block

	asl	len			; magic =)
	asl	len
	bpl	loop			; repeat once

	; printing an error message

	jsr	R1,print
	.word	21.*400+4

	br	.

print:	mov	(R1)+,R0
	emt	57			; set position
10$:	mov	#msg001,R0
	emt	64			; printing a line
	mov	R0,10$+2
	rts	R1

loadblock:

	; border flashing

	clr	R0
	sob	R0,.			; little pause before border change
	mov	#177716,R1		; beeper port
	mov	#140000,R5		; ROM start addr for audio data

	movb	#117,(R3)		; "border 5"
10$:	cmp	(pc),(pc)
	sob	R0,10$
	movb	#104,(R3)		; "border 3" instead of red,
20$:	cmp	(pc),(pc)			; because BK has limited palettes
	sob	R0,20$

pilot:

10$:	movb	#117,(R3)
	mov	#200,R0			; reset beeper
	movb	R0, @R1
	sob	R0,.
	movb	#104,(R3)
	movb	pc,@R1			; get sound, hardcoded
	mov	#170,R0
	sob	R0,.
	sob	R2,10$

data:

20$:	movb	(R5)+,R0
30$:	aslb	R0
	bcc	40$
	beq	60$
	movb	#104,(R3)		; "border 3" instead of blue
	movb	pc, @R1			; get sound, hardcoded
	br	50$
40$:	movb	#116,(R3)		; "border 6"
	movb	#200,@R1		; reset beeper
50$:	mov	#60,R2
	sob	R2,.
60$:	sob	R4,20$

	movb	#105,(R3)		; "border 7" after loading
	return

msg001:	.asciz	"Program: bad tape"
	.asciz	"Bytes: =MF2025="
	.asciz	"R Tape loading error, 0:1"

	.end
